# -*- coding: iso-8859-1 -*-

#####################################################################
# Daniel Calderon S.
# CC3501
#####################################################################

# 08_Nivel.py
# ---------------
# Manejo de muchos elementos
# Generacin aleatoria de meteoritos
# ---------------

# Implementacin testeada con:
## Python 2.6
## PyOpenGL 3.0.1
## PyGame 1.9.1

#####################################################################

# importar librera grfica
from OpenGL.GL import *
from OpenGL.GLU import *

# importar librera para manejar eventos
import pygame
from pygame.locals import *

# para simplificar la simulacn fsica,
# utiliza la clase Vector
from Vector2D import *

# para generar enteros aleatorios
from random import uniform

#####################################################################
# Funciones de inicializacin
#####################################################################

def init_pygame((w,h), title=""):
    pygame.init()
    pygame.display.set_mode((w,h), OPENGL|DOUBLEBUF)
    pygame.display.set_caption(title)
	
def init():
    glClearColor(0.0, 0.0, 0.0, 0.0)
    glClearDepth(1.0)
    glDisable(GL_DEPTH_TEST)
    glShadeModel(GL_SMOOTH)
    glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST)
    glEnable (GL_BLEND)
    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA)
    glHint (GL_LINE_SMOOTH_HINT, GL_NICEST)

def reshape((width, height)):
    if height == 0:
        height = 1
    glMatrixMode(GL_PROJECTION)
    glLoadIdentity()
    gluOrtho2D(0.0, width, 0.0, height)
    glMatrixMode(GL_MODELVIEW)
    glLoadIdentity()
	
def init_opengl((w,h)):
    init()
    reshape((w,h))

#####################################################################
# Definiendo clases...
#####################################################################

class Nave:
    def __init__(self):
        self.r = 30 # "radio" aprox de la nave
        self.p = Vector(0.0,100.0)  # posicion de la nave
        self.sp = 10 # cantidad de ataques especiales
        
    def dibujar(self):
        glPushMatrix()
        
        glTranslatef(self.p.x(),self.p.y(),0.0)
        glColor4f(1.0,1.0,1.0,1.0)

        glBegin(GL_POLYGON)
        
        glVertex2f(0,100)
        glVertex2f(30,0)
        glVertex2f(-30,0)

        glEnd()
        glPopMatrix()

class Meteorito:
    def __init__(self, r, p, v, o):
        self.r = r # "radio" aprox del meteorito
        self.p = p # posicion
        self.v = v # velocidad
        self.o = o # orientacion en grados del meteorito.
        self.vive = True # marca para poder eliminar ...
        self.rgb=[0.7,0.5,0.04,1.0]
		
        self.vive = True # marca para poder eliminar ...

    def mover(self,dt):
        # cinematica,
		
        ## modifica la posicion con la velocidad instantanea.
        self.p=sumar(self.p,ponderar(dt,self.v))
        
    def dibujar(self):
        glPushMatrix()
		
        glTranslatef(self.p.x(),self.p.y(),0.0)
        glScalef(self.r,self.r,0.0)
        glRotatef(self.o,0.0,0.0,1)
        glColor4fv(self.rgb)

        glBegin(GL_POLYGON)

        glVertex2f(-143/150.0,-26/150.0)
        glVertex2f(-154/150.0,86/150.0)
        glVertex2f(-66/150.0,167/150.0)
        glVertex2f(142/150.0,110/150.0)
        glVertex2f(175/150.0,-44/150.0)
        glVertex2f(155/150.0,-108/150.0)
        glVertex2f(53/150.0,-108/150.0)
        glVertex2f(-39/150.0,-149/150.0)
        glVertex2f(-162/150.0,-121/150.0)

        glEnd()
        glPopMatrix()

class Bala:
    def __init__(self, p, v):
        self.r = 5 # "radio" aprox de la bala
        self.p = p
        self.v = v
		
        self.vive = True # marca para poder eliminar ...
		
    def mover(self,dt):
        self.p=sumar(self.p,ponderar(dt,self.v))

    def dibujar(self):
        glPushMatrix()

        glTranslatef(self.p.x(),self.p.y(),0.0)
        glRotatef(self.v.anguloG(),0.0,0.0,1.0)
        glColor4f(1.0,1.0,0.0,1.0)

        glBegin(GL_POLYGON)

        glVertex2f(0,5.0)
        glVertex2f(10.0,0)
        glVertex2f(0,-5.0)

        glEnd()
        glPopMatrix()

#####################################################################
# Definiendo funciones...
#####################################################################

def estanChocando(a,b):
    return distancia(a.p,b.p) < (a.r + b.r)

def crearMeteorito():
    # crea un meteorito aleatorio
    r=uniform(Rmin,Rmax)
    p=Vector(uniform(0,w),h+Rmax)
    v=Vector(0,-0.05)
    o=uniform(0,360)
    return Meteorito(r,p,v,o)
	
def limpiar(cs):
    # saca los objetos destruidos del contenedor cs.
    n=len(cs)
    aux=[]

    for i in range(n):
        c=cs.pop(0)
        if c.vive:
            aux.append(c)

    for a in aux:
        cs.append(a)
		
#####################################################################

# las variables globales son vistas por todo el cdigo
global Rmin,Rmax,w,h

Rmin = 100.0 # "radio" maximo meteoritos
Rmax = 30.0 # "radio" minimo meteoritos

w=800 # ancho
h=600 # alto

# inicializando ...
init_pygame((w,h),"Titulo")
init_opengl((w,h))

# definiendo "actores"

## Contenedor de meteoritos
ms = []

## Contenedor de balaa
bs = []

## Nave
nave = Nave()

# generacin de meteoritos

t = 0 # contador de tiempo para generar meteoritos
T = 1000 # periodo de generacin de meteoritos

# medida de tiempo inicial
t0 = pygame.time.get_ticks()

run = True
while run:
    # 0: CONTROL DEL TIEMPO
	
    # tiempo actual
    t1 = pygame.time.get_ticks()
	
    # diferencial de tiempo asociado a la iteracin
    dt = (t1 - t0)
	
    # actualizar tiempo inicial para siguiente iteracin
    t0 = t1
	
    # 1: MANEJAMOS EVENTOS DE ENTRADA (TECLADO, MOUSE, ETC.)
    for event in pygame.event.get():
        # coordenadas del mouse
        mouse_pos=pygame.mouse.get_pos()
        nave.p.setX(mouse_pos[0])
		
        if event.type == QUIT:
            run = False
        if event.type == KEYDOWN:
            if event.key == K_ESCAPE:
                run = False
		
        if event.type == MOUSEBUTTONDOWN:
            p = nave.p.clon()
            v = Vector(0,0.5)
            bs.append(Bala(p,v))
				
    # 2: EJECUTAMOS LOGICA DE LA APLICACION
	
    for m in ms:
        m.mover(dt)
	
    for b in bs:
        b.mover(dt)
	
    for m in ms:
        for b in bs:
            if estanChocando(m,b):
                m.vive = False
                b.vive = False
				
    limpiar(ms)
    limpiar(bs)
	
    ## incrementa contador para generar meteoritos
    t += dt
	
    ## si corresponde, genera meteoritos y regenera el contador
    if t > T:
        t -= T
        ms.append(crearMeteorito())
        # formulacin alternativa de lo mismo...
        #ms = ms + [crearMeteorito()]
	
    # 3: DIBUJAMOS LOS ELEMENTOS
    glClear(GL_COLOR_BUFFER_BIT) # limpia la pantalla
	
    nave.dibujar()
	
    for m in ms:
        if m.vive:
            m.dibujar()
	
    for b in bs:
        if b.vive:
            b.dibujar()
	
    # vuelca el dibujo a la pantalla
    pygame.display.flip()

#####################################################################